<?php

/**
* Plugin Name: equiz
* Plugin URI: https://www.radicalbit.ir/
* Description: ساخت آزمون (در حال ساخت)
* Version: 0.1
* Author: eman
* Author URI: https://www.radicalbit.ir
**/

function equiz_admin_dashboard() {
    include('func.php');
    include('admin/home.php');
}
function equiz_admin_menu() {
  add_menu_page(
        'Quiz Maker',// page title
        'Quiz Maker',// menu title
        'manage_options',// capability
        'equiz',// menu slug
        'equiz_admin_dashboard' // callback function
    );
}
add_action('admin_menu', 'equiz_admin_menu');

function equiz_cssjs() {
    wp_register_style('style', plugins_url('cssjs/style.css?t='.time(),__FILE__ ));
    wp_enqueue_style('style');
    wp_register_style('bs', 'https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css');
    wp_enqueue_style('bs');
    
    wp_register_script('ejs1', plugins_url('cssjs/js1.js?t='.time(),__FILE__ ));
    wp_enqueue_script('ejs1');
}

add_action('admin_init','equiz_cssjs');

function equiz_shortcodes_init(){
    add_shortcode('eqm', 'equiz_eqm_form');
    add_shortcode('eqmr', 'equiz_eqm_result');
    add_shortcode('eqmp', 'equiz_eqm_placement');
}
add_action('init', 'equiz_shortcodes_init');

function equiz_eqm_form($atts){
    
    $ecachenumber = time();
    
    wp_register_script('e_angularjs', 'https://ajax.googleapis.com/ajax/libs/angularjs/1.6.9/angular.min.js');
    wp_enqueue_script('e_angularjs');
    wp_register_script('e_angularjs_route', 'https://ajax.googleapis.com/ajax/libs/angularjs/1.6.9/angular-route.js');
    wp_enqueue_script('e_angularjs_route');
    wp_register_script('ejs1', plugins_url('cssjs/js1.js?t='.$ecachenumber,__FILE__ ));
    wp_enqueue_script('ejs1');
    wp_register_script('e_siteapp', plugins_url('cssjs/site-app.js?t='.$ecachenumber, __FILE__));
    wp_enqueue_script('e_siteapp');
    wp_register_script('e_siteapp_ctrl_quizform', plugins_url('cssjs/site-ctrl-quizform.js?t='.$ecachenumber, __FILE__));
    wp_enqueue_script('e_siteapp_ctrl_quizform');
    wp_register_script('e_siteapp_ctrl_quizplacement', plugins_url('cssjs/site-ctrl-quizplacement.js?t='.$ecachenumber, __FILE__));
    wp_enqueue_script('e_siteapp_ctrl_quizplacement');
    wp_register_script('e_siteapp_ctrl_estimate', plugins_url('cssjs/site-ctrl-estimate.js?t='.$ecachenumber, __FILE__));
    wp_enqueue_script('e_siteapp_ctrl_estimate');
    wp_register_style('equiz_site_css', plugins_url('cssjs/site.css',__FILE__ ));
    wp_enqueue_style('equiz_site_css');
    
    $str = file_get_contents(__DIR__.'/site/home.php');
    return $str;
}

function equiz_eqm_result($atts){
    
    $ecachenumber = time();
    
    wp_register_script('e_angularjs', 'https://ajax.googleapis.com/ajax/libs/angularjs/1.6.9/angular.min.js');
    wp_enqueue_script('e_angularjs');
    wp_register_script('e_angularjs_route', 'https://ajax.googleapis.com/ajax/libs/angularjs/1.6.9/angular-route.js');
    wp_enqueue_script('e_angularjs_route');
    wp_register_script('ejs1', plugins_url('cssjs/js1.js?t='.$ecachenumber,__FILE__ ));
    wp_enqueue_script('ejs1');
    wp_register_script('e_siteapp_result', plugins_url('cssjs/site-app-result.js?t='.$ecachenumber, __FILE__));
    wp_enqueue_script('e_siteapp_result');
    wp_register_script('e_siteapp_ctrl_quizresult', plugins_url('cssjs/site-ctrl-quizresult.js?t='.$ecachenumber, __FILE__));
    wp_enqueue_script('e_siteapp_ctrl_quizresult');
    wp_register_script('e_siteapp_ctrl_quizresultpage', plugins_url('cssjs/site-ctrl-quizresultpage.js?t='.$ecachenumber, __FILE__));
    wp_enqueue_script('e_siteapp_ctrl_quizresultpage');
    wp_register_style('equiz_site_css', plugins_url('cssjs/site.css',__FILE__ ));
    wp_enqueue_style('equiz_site_css');
    
    $str = file_get_contents(__DIR__.'/site/result.php');
    return $str;
}

function equiz_eqm_placement($atts){
    
    $ecachenumber = time();
    
    $str = file_get_contents(__DIR__.'/site/placement.php');
    return $str;
}