<?php
require_once("../../../wp-load.php");

function calcraw($fid, $uid, $comp){
	    
	    global $wpdb;
	    
	    $useralist = $wpdb->get_row("select * from equiz_users_input where userid = $uid and form_id = $fid");
	    
	    $alist = json_decode($useralist->alist);
	    foreach($alist as $obj){
            
            $obj->correct = getqabody($comp, $obj->id)->pos - 1;
            
	    }
	    
	    $lessonlist = $wpdb->get_results("select * from equiz_lessons where form_id = $fid");
	    foreach($lessonlist as $lesson){
	        
	        foreach($alist as $obj){
	            
	            if($obj->lesson !== $lesson->id)continue;
	            $lesson->list[] = $obj;
	        }
	        
	        $lesson->correct = count(array_filter($lesson->list, function($x){return(isset($x->uapos) && $x->uapos == $x->correct);}));
            $lesson->incorrect = count(array_filter($lesson->list, function($x){return(isset($x->uapos) && $x->uapos != $x->correct);}));
            $lesson->unsel = count(array_filter($lesson->list, function($x){return(!isset($x->uapos));}));
            
            $lesson->raw = round((($lesson->correct * 3 - $lesson->incorrect) / (count($lesson->list) * 3)) * 100, 2);
            
            $resultraw[] = array('lesson_id' => $lesson->id, 'lesson_title' => $lesson->title, 'lesson_ratio' => $lesson->ratio, 'raw' => $lesson->raw);
	    }
	    
        //echo json_encode($resultraw);
        
        $wpdb->update('equiz_users_input', array('raw' => json_encode($resultraw)), array('userid' => $uid, 'form_id' => $fid));
	}
	
function getqabody($arr, $id){
    
    foreach($arr as $val)
        if($val->id == $id)
            return json_decode($val->body);
}

function lesson_avg_s($fid){
    
    global $wpdb;
    
    $lessonlist = $wpdb->get_results("select * from equiz_lessons where form_id = $fid");
    $useralist = $wpdb->get_results("select * from equiz_users_input");
    
    foreach($lessonlist as $lesson){
        foreach($useralist as $alist){
            
            $arr = json_decode($alist->raw);
            foreach($arr as $val){
                
                if($val->lesson_id != $lesson->id)continue;
                $lesson->sumlist[] = $val->raw;
            }
        }
        
        $lesson->avg = round(array_sum($lesson->sumlist) / count($lesson->sumlist), 2);
        $a = 0;
        foreach($lesson->sumlist as $val){
            
            $a += pow(($val - $lesson->avg), 2);
        }
        $s = round(pow(($a / count($lesson->sumlist)), 0.5), 2);
        
        $lesson->s = $s;
        
        $arrResult['lessons'][] = array('id' => $lesson->id, 'title' => $lesson->title, 'avg' => $lesson->avg, 's' => $lesson->s);
    }
    
    $wpdb->update('equiz_quizzes', array('result' => json_encode($arrResult)), array('id' => $fid));
    return $arrResult;
}

function calcZ($raw, $lesson_stats, $userinput_id){
    
    global $wpdb;
    
    $raw = json_decode($raw);

    foreach($raw as $valraw){
        
        foreach($lesson_stats['lessons'] as $vallesson){
            
            if($vallesson['id'] != $valraw->lesson_id)continue;
            
            $valraw->z = ($valraw->raw - $vallesson['avg']) / $vallesson['s'];
            $valraw->t = 1000 * $valraw->z + 5000;
        }
    }
    
    $data = array('raw' => json_encode($raw));
    
    $wpdb->update('equiz_users_input', $data, array('id' => $userinput_id));
    
    return $raw;
}

function calcLessonT($fid){
    
    global $wpdb;
    
    $lesson_stats = lesson_avg_s($fid);
    $useralist = $wpdb->get_results("select * from equiz_users_input where form_id = $fid");
    
    foreach($useralist as $alist){
        
        $res[] = calcZ($alist->raw, $lesson_stats, $alist->id);
    }
    //echo json_encode($res);
    
    calcT($fid);
}

function calcT($fid){
    
    global $wpdb;
    
    $useralist = $wpdb->get_results("select * from equiz_users_input where form_id = $fid");
    
    foreach($useralist as $valalist){
        
        $raw = json_decode($valalist->raw);
        $tsum = 0;
        $ratiosum = 0;
        foreach($raw as $valraw){
            
            $tsum += $valraw->t * $valraw->lesson_ratio;
            $ratiosum += $valraw->lesson_ratio;
        }
        $t = $tsum / $ratiosum;
        
        $wpdb->update('equiz_users_input', array('taraz' => $t), array('id' => $valalist->id));
    }
}

$fid = 1;

$comp = $wpdb->get_results("select * from equiz_qa where form_id = $fid");

$useralist = $wpdb->get_results("select * from equiz_users_input where form_id = $fid");

foreach($useralist as $val)
    calcraw($val->form_id, $val->userid, $comp);

calcLessonT($fid);