var eSiteQuiz = angular.module("eSiteQuiz", ["ngRoute"]);
eSiteQuiz.run(function($rootScope, $http, $location){
    
    $rootScope.cmdurl = '/wp-content/plugins/equiz/site.php';
    $rootScope.user = false;
    $rootScope.quizlist = [], $rootScope.resultlist = [];
    
    let objurl = new URL(location.href);
    $rootScope.quizid = objurl.searchParams.get('id');
    
    $rootScope.loaddata = () => {
        
        $http.post($rootScope.cmdurl, {req:'loaddata'}).then(r => {
            
            console.log(r.data);
            
            if(r.data.status){
                
                if(r.data.quizlist.status){
                    if(r.data.quizlist)$rootScope.quizlist = r.data.quizlist.list;
                }else{
                    $rootScope.errQuizList = r.data.quizlist.msg;
                }
                
                $rootScope.curct = r.data.curct;
                
                if(r.data.resultlist){
                    
                    if(r.data.resultlist.sd)$rootScope.resultlist = r.data.resultlist.sd;
                    if(r.data.resultlist.lessonlist)$rootScope.lessonlist = r.data.resultlist.lessonlist.list;
                }
                
                $rootScope.user = r.data.curuser;
                localStorage.equiz_user = JSON.stringify($rootScope.user);
            }else
                $rootScope.errmsg = r.data.errmsg;
        });
    };
    $rootScope.loaddata();
    
    $rootScope.loadquizinfo = () => {
        
        $http.post($rootScope.cmdurl, {req:'loadquizinfo', id:$rootScope.quizid}).then((r) => {
            
            console.log(r.data);
            if(r.data.info){
                $rootScope.quiztitle = r.data.info.title;
                $rootScope.quizinfo = r.data.info;
            }
            if(r.data.curuser.ID !== 0)$rootScope.user = r.data.curuser.data;
            console.log($rootScope.user);
            //countdownCreate($rootScope.quizinfo.quiz_length * 60);
            //countdownCreate(0 * 60 + 36);
        });
    };
    //$rootScope.loadquizinfo();
    
});

eSiteQuiz.controller('esitectrlQuizList', function($scope, $rootScope, $http, $location, $filter, $interval){
    
    $scope.openQuiz = (q, mode) => {
        
        $rootScope.quiz = q;
        
        localStorage.equiz_quiz = JSON.stringify(q);
        localStorage.equiz_lessonlist = JSON.stringify($rootScope.lessonlist);
        
        if(mode === 'view'){
        
            if($rootScope.resultlist && $rootScope.resultlist.find(x => x.id == $rootScope.quiz.id)){
                $rootScope.quizview = true;
                $location.path('view');
            }else
                alert('شما در این آزمون شرکت نکرده اید');
                
        }else{
            
            $rootScope.quizview = false;
            
            if(q.status_code == -1){
                
                if($rootScope.resultlist && $rootScope.resultlist.find(x => x.id == $rootScope.quiz.id))
                    $location.path('result');
                else
                    alert('شما در این آزمون شرکت نکرده اید');
            }else
                if($rootScope.resultlist && $rootScope.resultlist.find(x => x.id == $rootScope.quiz.id))
                    $location.path('result');
                else
                    $location.path('form');
        }
        
    };
    
});

eSiteQuiz.controller('esitectrlQuizResult', function($scope, $rootScope, $http, $location, $filter, $interval){
    
    $rootScope.quiz = $rootScope.quiz ? $rootScope.quiz : JSON.parse(localStorage.equiz_quiz);
    $rootScope.lessonlist = $rootScope.lessonlist ? $rootScope.lessonlist : JSON.parse(localStorage.equiz_lessonlist);
    
    $scope.curq = $rootScope.resultlist.find(x => x.id == $rootScope.quiz.id);
    
    $scope.firstResult = [];
    $scope.lessonlist = [];
    /*
    if(!$scope.curq){
        $scope.errmsg = $rootScope.resultlist.msg;
        console.log($scope.errmsg);
        return;
    }
    */
    $scope.lessonlist = $rootScope.lessonlist.filter(x => x.form_id === $rootScope.quiz.id);
    
    showchart = function(arr){
        
        xValues = [], yValues = [], barColors = [];
        for(let x of arr){
            
            xValues.push(x.lesson_title);
            yValues.push(x.raw);
            barColors.push("#" + ((1 << 24) * Math.random() | 0).toString(16).padStart(6, "0"));
        }

        new Chart("myChart", {
            type: "bar",
            data: {
                labels: xValues,
                datasets: [{
                    backgroundColor: barColors,
                    data: yValues
                }]
            },
            options: {
                legend: {display: false},
                title: {
                    display: true,
                    text: $rootScope.quiz.title
                }
            }
        });
    };
    
    $http.post($rootScope.cmdurl, {req:'myresult', qid:$rootScope.quiz.id}).then(r => {
        
        console.log(r.data);
        
        if(r.data.status){
            
            $scope.result = r.data.result;
            $scope.rawlist = r.data.result.raw;
            showchart($scope.rawlist);
        }
    });
    
    /*
    showTempResult = () => {
        
        $scope.lessonlist.forEach(lsn => {
            
            let arrqa = $scope.curq.alist.filter(x => lsn.id === x.lesson); console.log(arrqa);
            let obj = {};
            obj.lesson = lsn;
            obj.all = arrqa.length;
            obj.correct = arrqa.filter(x => x.pos === x.uapos).length;
            obj.unsel = arrqa.filter(x => x.uapos === false || x.uapos === undefined).length;
            obj.err = obj.all - (obj.correct + obj.unsel);
            obj.correct100 = Math.round((obj.correct * 3 - obj.err) * 100 / (obj.all * 3));
            
            $scope.firstResult.push(obj);
        });
        
        console.log($scope.firstResult);
        
        showchart($scope.firstResult);
    };
    showTempResult();
    */
});

eSiteQuiz.controller('esitectrlQuizView', function($scope, $rootScope, $http, $location, $filter, $interval){
    
    if(!$rootScope.user)$rootScope.user = JSON.parse(localStorage.equiz_user);
    if(!$rootScope.quiz)$rootScope.quiz = JSON.parse(localStorage.equiz_quiz);
    if(!$rootScope.lessonlist)$rootScope.lessonlist = JSON.parse(localStorage.equiz_lessonlist);
    
    $scope.lessonlist = $rootScope.lessonlist.filter(x => x.form_id === $rootScope.quiz.id);
    
    $http.post($rootScope.cmdurl, {req:'quizview', id:$rootScope.quiz.id}).then(r => {console.log(r.data);
        
        document.querySelectorAll(".esal").forEach(x => x.classList.remove('d-none'));
        document.querySelectorAll(".ehal").forEach(x => x.classList.add('d-none'));
        
        $scope.qalist = r.data.qalist;
        $scope.qalist.forEach(item => {
            
            let x = r.data.qacomp.find(x => x.id == item.id);
            item.pos = x.pos - 1;
            item.desc = x.desc;
            item.q = x.q;
            item.alist = x.alist;
        });
        
    });
});


eSiteQuiz.config(function($routeProvider){
	
	$routeProvider
	.when("/", {
		
		templateUrl:"/wp-content/plugins/equiz/site/quizlist.html",
		controller:"esitectrlQuizList"
	})
	.when("/form", {
		
		templateUrl:"/wp-content/plugins/equiz/site/quizform.html",
		controller:"esitectrlQuizForm"
	})
	.when("/result", {
		
		templateUrl:"/wp-content/plugins/equiz/site/quizresult.html",
		controller:"esitectrlQuizResult"
	})
	.when("/view", {
		
		templateUrl:"/wp-content/plugins/equiz/site/quizview.html",
		controller:"esitectrlQuizView"
	});
	
});