var eappQuiz = angular.module("eappQuiz", ["ngRoute"]);
eappQuiz.run(function($rootScope, $http, $location){
    
    $rootScope.cmdurl = '/wp-content/plugins/equiz/admin.php';
    
    $rootScope.quizlist = [], $rootScope.lessonlist = [], $rootScope.userlist = [], $rootScope.quizusers = [];
    
    $rootScope.loaddata = () => {
        
        $http.post($rootScope.cmdurl, {req:'loaddata'}).then((r) => {
            
            console.log(r.data);
            if(r.data.quizlist.list)$rootScope.quizlist = r.data.quizlist.list;
            if(r.data.lessonlist.list)$rootScope.lessonlist = r.data.lessonlist.list;
            if(r.data.userlist)$rootScope.userlist = r.data.userlist;
            if(r.data.quizusers)$rootScope.quizusers = r.data.quizusers;
            $rootScope.today = r.data.today;
            $rootScope.curct = r.data.curct;
        });
    };
    $rootScope.loaddata();
    
    $rootScope.back = () => window.history.back();
    
});

eappQuiz.controller('ectrlQuizResult', function($scope, $rootScope, $http, $location, $filter){
    
    console.log($rootScope.curQuizResult);
    
    $http.post($rootScope.cmdurl, {req:'quizresult', id:$rootScope.curQuizResult.id}).then(r => {
        
        console.log(r.data);
        
        $scope.result = r.data.result;
        for(let x of $scope.result)
            x.raw = JSON.parse(x.raw);
        console.log($scope.result);
    });
});

eappQuiz.filter('quizstatus', function($rootScope){
	
	return function(q){
		
		if($rootScope.curct < q.quiz_date_en_time){
		    return 'برگزار نشده';
		}else{
		    if($rootScope.curct - q.quiz_date_en_time > q.quiz_length * 60)
		        return 'برگزار شده';
            else
                return 'در حال برگزاری';
		}
	};
});

eappQuiz.config(function($routeProvider){
	
	$routeProvider
	.when("/", {
		
		templateUrl:"/wp-content/plugins/equiz/admin/formlist.html",
		controller:"ectrlFormList"
	})
	.when("/formpage", {
		
		templateUrl:"/wp-content/plugins/equiz/admin/formpage.html",
		controller:"ectrlFormPage"
	})
	.when("/quizresult", {
		
		templateUrl:"/wp-content/plugins/equiz/admin/quizresult.html",
		controller:"ectrlQuizResult"
	})
});