var eappQuiz = angular.module("eappQuiz", ["ngRoute"]);
eappQuiz.run(function($rootScope, $http, $location){
    
    $rootScope.cmdurl = '/wp-content/plugins/equiz/admin.php';
    
    $rootScope.quizlist = [], $rootScope.lessonlist = [], $rootScope.userlist = [], $rootScope.quizusers = [];
    $rootScope.fakeuserLessons = [];
    
    $rootScope.loaddata = () => {
        
        $http.post($rootScope.cmdurl, {req:'loaddata'}).then((r) => {
            
            console.log(r.data);
            if(r.data.quizlist.list)$rootScope.quizlist = r.data.quizlist.list; //.map(x => {x.fakeoption = []; return x;});
            if(r.data.lessonlist.list)$rootScope.lessonlist = r.data.lessonlist.list;
            if(r.data.userlist)$rootScope.userlist = r.data.userlist;
            if(r.data.quizusers)$rootScope.quizusers = r.data.quizusers;
            if(r.data.fakeuserLessons)$rootScope.fakeuserLessons = r.data.fakeuserLessons;  //.map(x => x.lesson_title);
            if(r.data.quizcatlist)$rootScope.quizcatlist = r.data.quizcatlist.list;
            $rootScope.today = r.data.today;
            $rootScope.curct = r.data.curct;
            $rootScope.quizlist.forEach(x => {
                x.result = JSON.parse(x.result);
                x.fakeoption = JSON.parse(x.fakeoption);
            });
            
            if(r.data.roles)$rootScope.roles = r.data.roles;
            //console.log($rootScope.fakeuserLessons);
        });
    };
    $rootScope.loaddata();
    
    $rootScope.back = () => window.history.back();
    
});

eappQuiz.controller('ectrlQuizResult', function($scope, $rootScope, $http, $location, $filter){
    
    if(!$rootScope.curQuizResult)
        $rootScope.curQuizResult = JSON.parse(localStorage.quizresult);
    
    console.log($rootScope.curQuizResult);
    
    $scope.allrows = [];
    
    $scope.sortlist = [
        {key:'ct', title:'زمان آزمون'},
        {key:'taraz', title:'نمره تراز'},
    ];
    $scope.resultsort = $scope.sortlist[0];
    
    $scope.sortrevs = false;
    
    $http.post($rootScope.cmdurl, {req:'quizresult', id:$rootScope.curQuizResult.id}).then(r => {
        console.log(r.data);
        
        $scope.allrows = r.data.allrows;
        
        //if($rootScope.curQuizResult.title.indexOf('آزمون تعیین سطح') >= 0)
        if($rootScope.curQuizResult.id == 23)
            $scope.result = r.data.result_placement;
        else{
            $scope.result = r.data.result;
            $scope.result.forEach(x => {
                
                x.fakepos = $scope.allrows.findIndex(a => a.taraz === x.taraz) + 1;
                x.realpos = $scope.allrows.filter(a => a.userid > 0).findIndex(a => a.taraz === x.taraz) + 1;
            });
        }
        
        for(let x of $scope.result)
            x.raw = JSON.parse(x.raw);
        
        $scope.userscount = r.data.userscount;
    });
});

eappQuiz.filter('quizstatus', function($rootScope){
	
	return function(q){
		
		if($rootScope.curct < q.quiz_date_en_time){
		    return 'برگزار نشده';
		}else{
		    if($rootScope.curct > q.quiz_date_en_time_end)
		        return 'برگزار شده';
            else
                return 'در حال برگزاری';
		}
	};
});

eappQuiz.config(function($routeProvider){
	
	$routeProvider
	.when("/", {
		
		templateUrl:"/wp-content/plugins/equiz/admin/formlist.html",
		controller:"ectrlFormList"
	})
	.when("/formpage", {
		
		templateUrl:"/wp-content/plugins/equiz/admin/formpage.html",
		controller:"ectrlFormPage"
	})
	.when("/quizresult", {
		
		templateUrl:"/wp-content/plugins/equiz/admin/quizresult.html",
		controller:"ectrlQuizResult"
	})
});