<?php
use Shuchkin\SimpleXLSX;
class eclsquiz{
    
	private $ct;
	private $input;
	
	function __construct(){
		
		date_default_timezone_set('Asia/Tehran');
		$this->ct = time();
		$this->input = json_decode(file_get_contents('php://input'), true);
		include('func.php');
	}
	
	function loaddata($r = true){
	    
	    global $wpdb;
	    
	    $quizlist = $this->generallist('equiz_quizzes');
	    /*
	    foreach($quizlist->list as $val)
            $val->result = json_decode($val->result);
        */
	    $data['quizlist'] = $quizlist;
	    $data['lessonlist'] = $this->generallist('equiz_lessons');
	    $data['quizusers'] = $wpdb->get_results("select quiz_id, user_id from equiz_users");
	    $data['fakeuserLessons'] = $this->fakeuserLessons();
	    $data['quizcatlist'] = $this->generallist('equiz_quiz_category');
	    $data['today'] = gregorian_to_jalali(date("Y-m-d"), '/');
	    $data['curct'] = time();
	    $data['curuser'] = wp_get_current_user();
	    $data['userlist'] = get_users();
	    $data['roles'] = $this->getUserRoles();
	    
	    if($r)
	        return $data;
        else
	        echo json_encode($data);
	}
	
	function generallist($tbl, $r = true){
    
        global $wpdb;
        
        $result = $wpdb->get_results("select * from $tbl where deleted = false");
        if($result)
            $arr = array('status' => true, 'list' => $result);
        else
            $arr = array('status' => false);
        
        if($r)
            return $arr;
        else
            echo json_encode($arr);
    }
	
	private function getUserRoles() {
        
        global $wp_roles;
    
        $all_roles = $wp_roles->roles;
        $editable_roles = apply_filters('editable_roles', $all_roles);
    
        //echo json_encode($editable_roles);
        return array_keys($wp_roles->get_names());
    }

	
	function placement_read_toggle(){
        
        global $wpdb;
        
        $p = $this->input['p'];
        
        $plc = $wpdb->get_var("select placement from equiz_users_input where form_id = 23 and ct = $p[ct]");
        $plc = json_decode($plc);
        if(isset($plc->read))
            $plc->read = !$plc->read;
        else
            $plc->read = true;
        
        //$wpdb->update('equiz_users_input', array('placement' => json_encode($plc)), array('form_id' => 23, ct' => $p['ct']));
        
        echo json_encode(array('read' => $plc->read, 'ct' => $p['ct']));
	}
	
	function setfakeoption(){
	    
	    global $wpdb;
	    $q = $this->input['q'];
	    $setdata = array('fakeoption' => json_encode($q['fakeoption']));
	    $result = $wpdb->update("equiz_quizzes", $setdata, array('id' => $q['id']));
	    
	    if($result)
	        $arr = array('status' => true, 'msg' => 'تغییرات با موفقیت ذخیره شد');
        else
            $arr = array(
                'status' => false,
                'msg' => 'اشکال. مجددا تلاش کنید'
            );
        
        echo json_encode($arr);
	}
	
	function fakeuserLessons(){
        
        global $wpdb;
        //$row = $wpdb->get_row("select * from equiz_fakeusers");
        
        $row = $wpdb->get_row("
            select eui.raw from equiz_users_input eui
            inner join equiz_quizzes on equiz_quizzes.id = eui.form_id
            where equiz_quizzes.category < 3 and equiz_quizzes.result is not null
            order by form_id desc
        ");
        
        if($row){
            return json_decode($row->raw);
        }else{
            return false;
        }
	}
	
	private function fakeusers_check($fid){
	    
	    global $wpdb;
	    $result = $wpdb->get_results("select * from equiz_users_input where userid = 0 and form_id = $fid");
	    if($result)
            return true;
        else
            return false;
	}
	
	function fakeusers_set2($r = true){
        
        global $wpdb;
        $fid = $this->input['qid'];
        
        $lessonlist = $wpdb->get_results("select * from equiz_lessons where form_id = $fid and deleted = false");
        
        $fakeoption = $wpdb->get_var("select fakeoption from equiz_quizzes where id = $fid");
        $fakeoption = json_decode($fakeoption);
        
        $intlsn = 0; $intfk = 0;
        
        foreach($lessonlist as $vallsn){
            $intlsn++;
            foreach($fakeoption as $valfake){
                if($vallsn->id == $valfake->id){
                    $valfake->title = $vallsn->title;
                    $valfake->ratio = $vallsn->ratio;
                    $intfk++;
                    break;
                }
            }
        }
        
        if($intlsn === $intfk){
            
            $intins = 0;
            
            $fakeusers = $wpdb->get_results("select * from equiz_fakeusers");
            /*
            $lastfakequiz_id = $wpdb->get_var("select max(id) as max from equiz_quizzes where result is not null");
            $fakeusers = $wpdb->get_results("select raw from equiz_users_input where form_id = $lastfakequiz_id");
            */
            foreach($fakeusers as $valfu){
                
                $newraw = array();
                
                $arrraw = json_decode($valfu->raw);
				
				foreach($fakeoption as $fakeopt){
				    
				    $arrtemp = array('lesson_id' => $fakeopt->id, 'lesson_ratio' => $fakeopt->ratio, 'lesson_title' => $fakeopt->title);
				    
				    foreach($arrraw as $valraw){
				        if($fakeopt->faketitle == $valraw->lesson_title){
				            $arrtemp['raw'] = $valraw->raw;
				            break;
				        }
				    }
				    
				    $newraw[] = $arrtemp;
				}
				
				/*
				foreach($arrraw as $valraw){
					foreach($lessonlist as $vallsn){
						
						if($vallsn->title == $valraw->lesson_title && $vallsn->ratio == $valraw->lesson_ratio)
							$valraw->lesson_id = $vallsn->id;
					}
				}
                */
                $insdata = array('userid' => 0, 'form_id' => $fid, 'raw' => json_encode($newraw));
                $resins = $wpdb->insert('equiz_users_input', $insdata);
                if($resins)$intins++;
            }
            
            $arr = array(
                'status' => true,
                'msg' => "تعداد $intins نفر اضافه شد"
            );
            
        }else
            $arr = array(
                'status' => false, 'lsncount' => $intlsn, 'fakecount' => $intfk,
                'msg' => 'ابتدا درسها را معادل سازی کنید'
            );
        
        echo json_encode($arr);
	}
	
	function fakeusers_set($r = true){
	    
	    global $wpdb;
	    $fid = $this->input['qid'];
	    
	    $existsfake = $this->fakeusers_check($fid);
	    if($existsfake){
	        
	        echo json_encode(array(
                'status' => false,
                'msg' => 'کاربران قبلا اضافه شدند'
            ));
            return;
	    }
	    
	    $lessonlist = $wpdb->get_results("select * from equiz_lessons where form_id = $fid and deleted = false");
	    $lessonlist_fake = $wpdb->get_row("select * from equiz_fakeusers");
	    $raw = json_decode($lessonlist_fake->raw);
	    $int1 = 0;
	    $intraw;
	    foreach($raw as $valraw){
	        $intraw++;
	        foreach($lessonlist as $vallsn){
	            if($vallsn->title == $valraw->lesson_title && $vallsn->ratio == $valraw->lesson_ratio){
					$int1++;
				}
	        }
	    }
	    
	    $intins = 0;
	    
	    if($intraw === $int1){
            
            $fakelist = $wpdb->get_results("select * from equiz_fakeusers");
            foreach($fakelist as $valfake){
				
				$arrraw = json_decode($valfake->raw);
				
				foreach($arrraw as $valraw){
					foreach($lessonlist as $vallsn){
						
						if($vallsn->title == $valraw->lesson_title && $vallsn->ratio == $valraw->lesson_ratio)
							$valraw->lesson_id = $vallsn->id;
					}
				}
                
                $insdata = array('userid' => 0, 'form_id' => $fid, 'raw' => json_encode($arrraw));
                $resins = $wpdb->insert('equiz_users_input', $insdata);
                if($resins)$intins++;
            }
            $arr = array(
                'status' => true,
                'msg' => "تعداد $intins نفر اضافه شد"
            );
        }else
            $arr = array(
                'status' => true, 'quantity' => $int1, 'intraw' => $intraw,
                'msg' => 'عنوان یا ضریب درس ها اختلاف دارد'
            );
	    
	    echo json_encode($arr);
	}
	
	function setusers($r = true){
	    
	    global $wpdb;
	    
	    $id = $this->input['id'];
	    $users = $this->input['users'];
	    $tbl = 'equiz_users';
	    
	    $wpdb->delete($tbl, array('quiz_id' => $id));
	    
	    foreach($users as $val){
            
            $data = array('quiz_id' => $id, 'user_id' => $val, 'ct' => $this->ct);
            $wpdb->insert($tbl, $data);
	    }
	    
	    $arr = array(
	        'status' => true,
	        'quizusers' => $wpdb->get_results("select quiz_id, user_id from equiz_users")
	    );
	    
	    echo json_encode($arr);
	}
	
	function answerfile(){
        
        global $wpdb;
        
        $form_id = $_POST['fid'];
        
        $folder = 'uploads/answerfile/';
        if(!file_exists($folder))mkdir($folder);
        
        $ext = pathinfo($_FILES['file']['name'],PATHINFO_EXTENSION);
        $file = $folder.$form_id.'.'.$ext;
        move_uploaded_file($_FILES["file"]["tmp_name"], $file);
        
        $result = $wpdb->update('equiz_quizzes', array('answerfile' => $file), array('id' => $form_id));
        echo json_encode(array('status' => $result, 'filepath' => $file));
	}
	
	function importQ(){
	    
        global $wpdb;
        
        $folder = 'uploads/';
        if(!file_exists($folder))mkdir($folder);
        
        $ext = pathinfo($_FILES['file']['name'],PATHINFO_EXTENSION);
        $file = $folder.$this->ct.'.'.$ext;
        move_uploaded_file($_FILES["file"]["tmp_name"], $file);
        
        $form_id = $_POST['fid'];
        $lesson = $_POST['lesson_id'];
        
        $tbl = 'equiz_qa';
        
        if($ext === 'txt')
            $arrq = $this->qfromtxt($file);
        elseif($ext === 'docx')
            $arrq = $this->qfromdoc($file);
        elseif($ext === 'xlsx')
            $arrq = $this->qfromxls($file);
        
        if(file_exists($file))unlink($file);
        
        //$arrobj = array();     //Test
        foreach($arrq as $key => $val){
            
            if($ext === 'xlsx'){
                
                $obj = array(
    				'ct' => $this->ct,
    				'no' => $key + 1,
    				'q' => $val[0],
    				'pos' => (int)$val[5],
    				'desc' => $val[6],
    				'lesson' => $lesson
    			);
    			for($i = 1; $i <= 4; $i++)
    				$obj['alist'][] = $val[$i];
    				
            }else{
            
                $obj = array(
                    'ct' => $this->ct,
                    'no' => $key + 1,
                    'q' => $val['Q'],
                    'pos' => $this->A1D4($val['Correct']),
                    'alist' => array($val['A'], $val['B'], $val['C'], $val['D']),
                    'desc' => isset($val['InCorrect']) ? $val['InCorrect'] : $val['Desc'],
                    'lesson' => $lesson
                );
            }
            
            //$arrobj[] = $obj;     //Test
            
            $data = array('body' => json_encode($obj), 'form_id' => $form_id, 'ct' => $this->ct, 'no' => $key + 1);
            //$format = array('%s', '%d', '%d');
            $result = $wpdb->insert($tbl,$data);
            
            if($result){
                $lid = $wpdb->insert_id;
                $obj['id'] = $lid;
                $wpdb->update($tbl, array('body' => json_encode($obj)), array('id' => $lid));
            }
            
        }
        //echo json_encode($arrobj);    //Test
        
	}
	
	private function A1D4($str){
	    
	    $num = null;
	    if($str === 'A' || $str === 'الف')$num = 1;
	    elseif($str === 'B' || $str === 'ب')$num = 2;
	    elseif($str === 'C' || $str ==='ج')$num = 3;
	    elseif($str === 'D' || $str = 'د')$num = 4;
	    
	    return $num;
	}
	
	private function qfromxls($file){
	    
	    ini_set('error_reporting', E_ALL);
		ini_set('display_errors', true);

		require_once 'SimpleXLSX.php';

		$filename = $file;

		if($xlsx = SimpleXLSX::parse($filename)){
			$arrRows = $xlsx->rows();
			//echo json_encode($arrRows);
			return $arrRows;
		}else
			return SimpleXLSX::parseError();
	}
	
	private function qfromtxt($file){
	    
	    $page = file_get_contents($file);
	    $arr0 = explode('#', $page);
        $arr1 = [];
	    foreach($arr0 as $qa){
	        $qa = trim($qa);
	        if(strlen($qa) < 1)continue;
	        $arrQ = explode('الف:)', $qa);
	        $arrA = explode('ب:)', $arrQ[1]);
	        $arrB = explode('ج:)', $arrA[1]);
	        $arrC = explode('د:)', $arrB[1]);
	        $arrD = explode('پ:)', $arrC[1]);
	        $arrCorrect = explode('ت:)', $arrD[1]);
	        
	        $arrTemp = array(
	            'Q' => trim($arrQ[0], 'س:)'),
	            'A' => $arrA[0],
	            'B' => $arrB[0],
                'C' => $arrC[0],
                'D' => $arrD[0],
                'Correct' => $arrCorrect[0],
                'Desc' => $arrCorrect[1]
            );
            foreach($arrTemp as $k => $v)$arrTemp[$k] = trim($v);
            $arr1[] = $arrTemp;
	    }
	    
	    return $arr1;
	}
	
	private function qfromdoc($file){
	    
	    include('clsdocx.php');
	    
        $clsdocread = new clsDocx();
        $str = $clsdocread->extracttext($file);
        
        $arr0 = explode('Q:)', $str);
        $arr1 = [];
        foreach($arr0 as $key => $val){if($key === 0)continue;
            
            $arrQ = explode('A:)', $val);
            $arrA = explode('B:)', $arrQ[1]);
            $arrB = explode('C:)', $arrA[1]);
            $arrC = explode('D:)', $arrB[1]);
            $arrD = explode(':Correct:', $arrC[1]);
            $arrCorrect = explode(':MsgCorrect:', $arrD[1]);
            $arrInCorrect = explode(':MsgIncorrect:', $arrCorrect[1]);
            
            $arrTemp = array(
                'Q' => trim($arrQ[0], ':Type: S'),
                'A' => $arrA[0],
                'B' => $arrB[0],
                'C' => $arrC[0],
                'D' => $arrD[0],
                'Correct' => $arrCorrect[0],
                'InCorrect' => $arrInCorrect[1]
            );
            foreach($arrTemp as $k => $v)$arrTemp[$k] = trim($v);
            
            $arr1[] = $arrTemp;
        }

        return $arr1;
	}
	
	function quizsave($r){
	    
	    global $wpdb;
        
        $title = $this->input['title'];
        $desc = $this->input['desc'];
        $quizdate = $this->input['date'];
        $quizhour = $this->input['hour'];
        $quizminute = $this->input['minute'];
        
        $quizdate_end = $this->input['date_end'];
        $quizhour_end = $this->input['hour_end'];
        $quizminute_end = $this->input['minute_end'];
        
        $quizlength = $this->input['len'];
        
        $arrDateEn = jalali_to_gregorian($quizdate);
        $quiz_date_en_time = mktime($quizhour, $quizminute, 0, $arrDateEn[1], $arrDateEn[2], $arrDateEn[0]);
        
        $arrDateEn_end = jalali_to_gregorian($quizdate_end);
        $quiz_date_en_time_end = mktime($quizhour_end, $quizminute_end, 0, $arrDateEn_end[1], $arrDateEn_end[2], $arrDateEn_end[0]);
        
        $quizcat = $this->input['category'];
        
        $ea = $this->input['ea'];
        
        $data = array(
            'title' => $title, 'description' => $desc, 'category' => $quizcat,
            'quiz_date' => $quizdate, 'quiz_hour' => $quizhour, 'quiz_minute' => $quizminute, 'quiz_length' => $quizlength, 'quiz_date_en_time' => $quiz_date_en_time,
            'quiz_date_end' => $quizdate_end, 'quiz_hour_end' => $quizhour_end, 'quiz_minute_end' => $quizminute_end, 'quiz_date_en_time_end' => $quiz_date_en_time_end
        );
        
        $tbl = 'equiz_quizzes';
        
        if($ea === 'A'){
            
            $data['ct'] = $this->ct;
            $result = $wpdb->insert($tbl, $data);
            
        }else{
            
            $id = $this->input['id'];
            $result = $wpdb->update($tbl, $data, array('id' => $id));
        }
        
        if($result !== false){
            
            $arr = array('status' => true);
            if($ea === 'A'){
                
                $arr['quiz'] = $wpdb->get_row("select *, concat('/quiztest/?id=', ct) as link from $tbl where id=".$wpdb->insert_id);
                $arr['link'] = '/quiztest/?id='.$this->ct;
                $arr['msg'] = 'آزمون با موفقیت ثبت شد و از طریق لینک زیر در دسترس است';
                
            }else{
                
                $arr['quiz'] = $wpdb->get_row("select *, concat('/quiztest/?id=', ct) as link from $tbl where id=".$id);
                $arr['msg'] = 'تغییرات با موفقیت ذخیره شد';
            }
        }else
            $arr = array(
                'status' => false,
                'msg' => 'Error'
            );
        
        if($r)
            return $arr;
        else
            echo json_encode($arr);
	}
	
	function lesson_save(){
	    
	    global $wpdb;
	    
	    $ea = $this->input['ea'];
	    
	    $data = array(
	        'title' => $this->input['title'],
	        'ratio' => $this->input['ratio'],
	        'form_id' => $this->input['fid']
        );
	    
	    $tbl = 'equiz_lessons';
	    
	    if($ea === 'A'){
	        
	        $data['ct'] = $this->ct;
	        $result = $wpdb->insert($tbl, $data);
	        $rowct = $this->ct;
	        
	    }else{
	        
	        $ct = $this->input['ct'];
	        $result = $wpdb->update($tbl, $data, array('ct' => $ct));
	        $rowct = $ct;
	    }
	    
	    if($result){
	        $row = $wpdb->get_row("select * from $tbl where ct = $rowct");
	        $arr = array('status' => true, 'lesson' => $row);
	    }else
	        $arr = array('status' => false, 'msg' => 'Error!');
	        
	    echo json_encode($arr);
	}

	function quizdel($r = true){
	    
	    global $wpdb;
        
        $id = $this->input['id'];
        $result = $wpdb->update('equiz_quizzes', array('deleted' => true), array('id' => $id));
        if($result)
            $arr = array('status' => true);
        else
            $arr = array('status' => false);
        
        echo json_encode($arr);
	}
	
	function quizinfo($r = true, $id = null){
	    
	    global $wpdb;
        
        if($id === null)$id = $this->input['id'];
        $result = $wpdb->get_results("select * from equiz_qa where deleted = false and form_id = $id");
        
        if($result !== false){
            
            foreach($result as $val)
                $qalist[] = json_decode($val->body);
            $arr = array('status' => true, 'qalist' => $qalist);
        }else
            $arr = array('status' => false);
        
        if($r)
            return $arr;
        else
            echo json_encode($arr);
	}
	
	function qasave($r = true){
	    
	    global $wpdb;
        
        $obj = $this->input['obj'];
        $fid = $this->input['fid'];
        $act = $this->input['act'];
        
        $tbl = 'equiz_qa';
        
        if($act === 'A'){
            
            $obj['ct'] = $this->ct;
            $no = $this->nextno($fid);
            $obj['no'] = $no;
            $data = array('body' => json_encode($obj), 'form_id' => $fid, 'ct' => $this->ct, 'no' => $no);
            $result = $wpdb->insert($tbl,$data);
            
            if($result){
                $lid = $wpdb->insert_id;
                $obj['id'] = $lid;
                $wpdb->update($tbl, array('body' => json_encode($obj)), array('id' => $lid));
            }
            
        }elseif($act === 'E'){
            
            $data = array('body' => json_encode($obj));
            $where = array('id' => $obj['id']);
            
            $result = $wpdb->update($tbl, $data, $where);
        }else
            $result = false;
        
        if($result !== false){
            $arr = array('status' => true, 'id' => $obj['id']);
        }else
            $arr = array('status' => false, 'msg' => $obj['id']);
        
        echo json_encode($arr);
	}
	
	private function nextno($quizid){
	    
        global $wpdb;
        $result = $wpdb->get_results("select * from equiz_qa where form_id = $quizid");
        foreach($result as $val){
            $body = json_decode($val->body);
            if(isset($body->no))
                $arr[] = $body->no;
	    }
	    $no = max($arr);
	    return $no + 1;
	}
	
	function rowdel($tbl, $r = true){
	    
	    global $wpdb;
        
        if(isset($this->input['id']))
            $where['id'] = $this->input['id'];
        else
            $where['ct'] = $this->input['ct'];
        
        $result = $wpdb->update($tbl, array('deleted' => true), $where);
        if($result)
            $arr = array('status' => true);
        else
            $arr = array('status' => false);
        
        echo json_encode($arr);
	}
	
	function quizresult($r = true){
	    
	    global $wpdb;
	    
	    $id = $this->input['id'];
	    
	    $result = $wpdb->get_results("
	        select qui.*, users.*
	        from equiz_users_input qui
	        inner join (select ID as uid, user_login as title from wpsc_users) users on users.uid = qui.userid
	        where qui.form_id = $id and qui.raw is not null and qui.deleted = false
        ");
	    
	    foreach($result as $val){
	        
	        $user = get_user_by('id', $val->uid);
	        if($user)
	            $val->user = $this->getUserData($user);
	            $val->finish_datetime = gregorian_to_jalali(date("Y-m-d", $val->ct), '/')." ".date("H:i", $val->ct);
	    }
	    
	    $result_placement = $wpdb->get_results("select placement, alist, raw, ct from equiz_users_input where placement is not null");
	    foreach($result_placement as $val){
        
            $val->finish_datetime = gregorian_to_jalali(date("Y-m-d", $val->ct), '/')." ".date("H:i", $val->ct);
            $val->user = json_decode($val->placement);
            $val->user->display_name = $val->user->name;
	    }
	    
	    $userscount = $wpdb->get_var("select count(*) from equiz_users_input where deleted = false and form_id = $id and raw is not null");
	   
	    $allrows = $wpdb->get_results("select userid, taraz from equiz_users_input where form_id = $id and raw is not null order by taraz desc");
	    
	    $arr = array('result' => $result, 'result_placement' => $result_placement, 'userscount' => $userscount, 'allrows' => $allrows);
	    echo json_encode($arr);
	}
	
	private function lesson_avg_s($fid){
		
		global $wpdb;
		
		$lessonlist = $wpdb->get_results("select * from equiz_lessons where form_id = $fid and deleted = false");
		$useralist = $wpdb->get_results("select * from equiz_users_input");
		
		foreach($lessonlist as $lesson){
			foreach($useralist as $alist){
				
				$arr = json_decode($alist->raw);
				foreach($arr as $val){
					
					if($val->lesson_id != $lesson->id)continue;
					$lesson->sumlist[] = $val->raw;
				}
			}
			
			$lesson->avg = round(array_sum($lesson->sumlist) / count($lesson->sumlist), 2);
			$a = 0;
			foreach($lesson->sumlist as $val){
				
				$a += pow(($val - $lesson->avg), 2);
			}
			$s = round(pow(($a / count($lesson->sumlist)), 0.5), 2);
			
			$lesson->s = $s;
			
			$arrResult['lessons'][] = array('id' => $lesson->id, 'title' => $lesson->title, 'avg' => $lesson->avg, 's' => $lesson->s);
		}
		
		$wpdb->update('equiz_quizzes', array('result' => json_encode($arrResult)), array('id' => $fid));
		return $arrResult;
	}

	private function calcZ($raw, $lesson_stats, $userinput_id){
		
		global $wpdb;
		
		$raw = json_decode($raw);

		foreach($raw as $valraw){
			
			foreach($lesson_stats['lessons'] as $vallesson){
				
				if($vallesson['id'] != $valraw->lesson_id)continue;
				
				$valraw->z = ($valraw->raw - $vallesson['avg']) / $vallesson['s'];
				$valraw->t = 1000 * $valraw->z + 5000;
			}
		}
		
		$data = array('raw' => json_encode($raw));
		
		$wpdb->update('equiz_users_input', $data, array('id' => $userinput_id));
		
		return $raw;
	}

	function calcLessonT($fid = null, $r = false){
		
		global $wpdb;
		
		if($fid == null)
			$fid = $this->input['id'];
		
		$lesson_stats = $this->lesson_avg_s($fid);
		$useralist = $wpdb->get_results("select * from equiz_users_input where form_id = $fid");
		
		foreach($useralist as $alist){
			
			$res[] = $this->calcZ($alist->raw, $lesson_stats, $alist->id);
		}
		//echo json_encode($res);
		
		$int1 = $this->calcT($fid);
		
		$this->calc70($fid);
		
		$arr = array('status' => true, 'quantity' => $int1);
		if($r)
		    return $arr;
        else
            echo json_encode($arr);
	}

	private function calcT($fid){
		
		global $wpdb;
		
		$useralist = $wpdb->get_results("select * from equiz_users_input where form_id = $fid");
		$intupdate = 0;
		foreach($useralist as $valalist){
			
			$raw = json_decode($valalist->raw);
			$tsum = 0;
			$ratiosum = 0;
			foreach($raw as $valraw){
				
				$tsum += $valraw->t * $valraw->lesson_ratio;
				$ratiosum += $valraw->lesson_ratio;
			}
			$t = $tsum / $ratiosum;
			
			$t = $t * 1.3;
			
			$resupdate = $wpdb->update('equiz_users_input', array('taraz' => $t), array('id' => $valalist->id));
			if($resupdate)$intupdate++;
		}
		
		return $intupdate;
	}

	private function calc70($id){
	    
	    global $wpdb;
	    $results = $wpdb->get_results("select * from equiz_users_input where deleted = false and form_id = $id and taraz is not null");
	    $intall = $wpdb->num_rows;
    
        foreach($results as $val){
            $arrTaraz[] = $val->taraz;
        }
        rsort($arrTaraz);
        $sumtaraz = 0;
        $userscount = round($intall / 100);
        for($i = 0; $i < $userscount; $i++){
            $sumtaraz += $arrTaraz[$i];
        }
        
        $avg1 = round($sumtaraz / $userscount);
        $avg70 = round($sumtaraz / $userscount * 0.7);
        
        $quizrow = $wpdb->get_row("select * from equiz_quizzes where id = $id");
        $objresult = json_decode($quizrow->result);
        $objresult->taraz = array('avg1' => $avg1, 'avg70' => $avg70);
		
		$wpdb->update('equiz_quizzes', array('result' => json_encode($objresult)), array('id' => $id));
	}
	
	private function checktaraz($id){
	    
	    global $wpdb;
	    $int1 = $wpdb->get_var("select count(*) from equiz_users_input where form_id = $id and raw is not null and taraz is null");
	    return $int1;
	}
	
	//***** SITE *****
	
	private function getUserData($user){
	    
	    return array(
	        'user_login' => $user->data->user_login,
            'display_name' => $user->data->display_name,
            'user_status' => $user->data->user_status
        );
	}
	
	function site_quizlist($r = true){
    
        global $wpdb;
        
        $curuser = wp_get_current_user();
        
        $result = $wpdb->get_results("
            select q.*, u.*
            from equiz_quizzes q
            inner join (select user_id, quiz_id from equiz_users) u on u.quiz_id = q.id
            where q.deleted = false and u.user_id = $curuser->ID
        ");
        
        foreach($result as $q){
            
            if($this->ct < $q->quiz_date_en_time){
    		    $q->status_text = 'برگزار نشده';
    		    $q->status_code = 1;
    		}else{
    		    if($this->ct > $q->quiz_date_en_time_end){
    		    //if($this->ct - $q->quiz_date_en_time > $q->quiz_length * 60){
    		        $q->status_text = 'برگزار شده';
    		        $q->status_code = -1;
                }else{
                    $q->status_text = 'در حال برگزاری';
                    $q->status_code = 0;
                }
    		}
    		
    		$q->result = json_decode($q->result);
        }
        
        if($result)
            $arr = array('status' => true, 'list' => $result);
        else
            $arr = array('status' => false, 'msg' => 'آزمونی برای شما وجود ندارد');
        
        if($r)
            return $arr;
        else
            echo json_encode($arr);
    }
	
	function site_loaddata(){
	    
	    $curuser = wp_get_current_user();
	    if($curuser->ID === 0){
	        
	        echo json_encode(array('status' => false, 'errmsg' => 'جهت مشاهده آزمون وارد سایت شوید'));
	        return;
	    }
	    
	    $data['quizlist'] = $this->site_quizlist(true);
	    $data['today'] = gregorian_to_jalali(date("Y-m-d"), '/');
	    $data['curct'] = time();
	    $data['curuser'] = $this->getUserData($curuser);
	    $data['resultlist'] = $this->site_resultdata();
	    $data['quizcatlist'] = $this->generallist('equiz_quiz_category');
	    $data['lessonlist'] = $this->generallist('equiz_lessons');
	    $data['status'] = true;
	    
	    echo json_encode($data);
	}
	
	function site_quizinfo($r = true){
    
        global $wpdb;
        
        $ct = $this->input['ct'];
        $user = wp_get_current_user();
       
        $result = $wpdb->get_row("select * from equiz_quizzes where deleted = false and ct = $ct");
        if($result !== false){
            
            $dupquiz = $wpdb->get_var("select count(*) from equiz_users_input where userid = ".$user->ID." and form_id = ".$result->id);
            
            $arr = array('status' => true, 'info' => $result, 'curct' => $this->ct, 'dupquiz' => (int)$dupquiz);
            if($dupquiz)$arr['msg'] = 'شما در این آزمون شرکت کرده اید';
            
            @$this->logsave(array('act' => 'enter quiz page', 'fn' => 'site_quizinfo', 'ua' => 'u'));
            
        }else{
            
            $arr = array('status' => false);
            @$this->logsave(array('act' => 'enter quiz page', 'fn' => 'site_quizinfo', 'ua' => 'u', 'err' => true));
        }
        
        $arr['curuser'] = $this->getUserData($user);
        
        if($r)
            return $arr;
        else
            echo json_encode($arr);
	}
	
	function site_quizstart($r){
	    
        $result = $this->quizinfo();
        if($result['status'] !== false){
            
            foreach($result['qalist'] as $val){
               
                $val->pos = null;
                $val->desc = null;
                $qalist[] = $val;
            }
            
            $arr = array('status' => true, 'qalist' => $qalist, 'lessonlist' => $this->generallist('equiz_lessons'));
            @$this->logsave(array('act' => 'start', 'fn' => 'site_quizstart', 'ua' => 'u'));
        }else{
            
            $arr = array('status' => false);
            @$this->logsave(array('act' => 'start', 'fn' => 'site_quizstart', 'ua' => 'u', 'err' => true));
        }
        
        if($r)
            return $arr;
        else
            echo json_encode($arr);
	}
	
	private function logsave($arr){
	    
	    global $wpdb;
	    
	    $user = wp_get_current_user();
	    $arr['userid'] = $user->ID;
	    $arr['ct'] = $this->ct;
	    $arr['ip'] = $_SERVER['REMOTE_ADDR'];
	    
	    switch($arr['act']){
            
            case 'start':
            case 'finish':
            case 'quizview':
                $arr['quiz_id'] = $this->input['id'];
                break;
            
            case 'enter quiz page':
                $arr['quiz_ct'] = $this->input['ct'];
                $arr['quiz_id'] = $wpdb->get_var("select id from equiz_quizzes where ct = ".$this->input['ct']);
                break;
	    }
	    
	    $wpdb->insert('equiz_logs', $arr);
	}
	
	function site_quizfinish($r){
	    
	    global $wpdb;
        
        $user = wp_get_current_user();
        
        $qalist = $this->input['qalist'];
        $fid = $this->input['id'];
        
        $data = ['alist' => json_encode($qalist), 'form_id' => $fid, 'ct' => $this->ct, 'userid' => $user->ID];
        
        if(isset($this->input['placement'])){
            
            $data['placement'] = json_encode($this->input['placement']);
            $this->site_placementform();
        }
        
        $result = $wpdb->insert('equiz_users_input', $data);
        if($result){
            
            $complete_list = $this->quizinfo()['qalist'];
            $arr = array('status' => true, 'qalist_complete' => $complete_list);
            
            $this->calcraw($fid, $user->ID, $complete_list, $wpdb->insert_id);
            
            @$this->logsave(array('act' => 'finish', 'fn' => 'site_quizfinish', 'ua' => 'u'));
            
        }else{
            
            $arr = array('status' => false, 'msg' => 'Error');
            @$this->logsave(array('act' => 'finish', 'fn' => 'site_quizfinish', 'ua' => 'u', 'err' => true));
        }
        
        echo json_encode($arr);
	}
	
	private function calcraw($fid, $uid, $comp, $lid){
	    
	    global $wpdb;
	    $useralist = $wpdb->get_row("select * from equiz_users_input where id = $lid");
	    $alist = json_decode($useralist->alist);
	    //$alist = json_decode($alist);
	    /*
	    foreach($alist as $obj)
            $obj->correct = $this->getqabody($comp, $obj->id)->pos - 1;
        */
        
        foreach($alist as $obj){
            foreach($comp as $val){
                
                if($val->id === $obj->id){
                    
                    $obj->correct = $val->pos - 1;
                    break;
                }
            }
        }
        
	    $lessonlist = $wpdb->get_results("select * from equiz_lessons where form_id = $fid and deleted = false");
	    foreach($lessonlist as $lesson){
	        
	        foreach($alist as $obj){
	            
	            if($obj->lesson !== $lesson->id)continue;
	            $lesson->list[] = $obj;
	        }
	        
	        $lesson->correct = count(array_filter($lesson->list, function($x){return(isset($x->uapos) && $x->uapos == $x->correct);}));
	        $lesson->incorrect = count(array_filter($lesson->list, function($x){return(isset($x->uapos) && $x->uapos != $x->correct && $x->uapos !== false);}));
            $lesson->unsel = count(array_filter($lesson->list, function($x){return(!isset($x->uapos) || $x->uapos === false);}));
            
            /*
            $lesson->incorrect = count(array_filter($lesson->list, function($x){return(isset($x->uapos) && $x->uapos != $x->correct);}));
            $lesson->unsel = count(array_filter($lesson->list, function($x){return(!isset($x->uapos));}));
            */
            
            $lesson->raw = round((($lesson->correct * 3 - $lesson->incorrect) / (count($lesson->list) * 3)) * 100, 2);
            
            $resultraw[] = array(
                'lesson_id' => $lesson->id, 'lesson_title' => $lesson->title, 'lesson_ratio' => $lesson->ratio,
                'raw' => $lesson->raw, 'correct' => $lesson->correct, 'incorrect' => $lesson->incorrect, 'unsel' => $lesson->unsel,
                'quantity' => count($lesson->list)
            );
            
            //$resultraw[] = $lesson;
	    }
        
        $wpdb->update('equiz_users_input', array('raw' => json_encode($resultraw)), array('id' => $lid));
	}
	
	private function getqabody($arr, $id){
        
        foreach($arr as $val)
            if($val->id == $id)
                return json_decode($val->body);
    }
    
	function site_resultdata($r = true){
	    
	    global $wpdb;
	    
	    $user = wp_get_current_user();
	    if($user->ID){
	        
    	    $result = $wpdb->get_results("
    	        select qui.alist, qui.ctime, qui.ct, qui.form_id,
    	        forms.*
    	        from equiz_users_input qui
    	        inner join(select id, title from equiz_quizzes) forms on forms.id = qui.form_id
    	         where deleted = 0 and userid = $user->ID
            ");
            
            if($result){
                
                foreach($result as $val){
                    $val->alist = json_decode($val->alist);
                    $val->main = $this->quizinfo(true, $val->id)['qalist'];
                    $val->quizdate = gregorian_to_jalali(date("Y-m-d", $val->ct), '/');
                }
                $arr = array('status' => true, 'sd' => $result, 'lessonlist' => $this->generallist('equiz_lessons'), 'user' => $this->getUserData($user));
            }else
                $arr = array('status' => false, 'msg' => 'شما هنوز در آزمونی شرکت نکردید');
	    }else
	        $arr = array('status' => false, 'msg' => 'برای مشاهده نتیجه آزمون، ابتدا وارد سایت شوید');
        
        if($r)
            return $arr;
        else
            echo json_encode($arr);
	}
	
	function site_myresult($r = true){
        
        $qid = $this->input['qid'];
        
        global $wpdb;
        
        $user = wp_get_current_user();
        
        $users_quantity = $wpdb->get_var("select count(*) from equiz_users_input where deleted = false and form_id = $qid and taraz is not null");
        
        $row = $wpdb->get_row("select * from equiz_users_input where deleted = false and userid = $user->ID and form_id = $qid");
        if($row){
            
            $resultall = $wpdb->get_results("select * from equiz_users_input where deleted = false and form_id = $qid and taraz is not null");
            if($resultall){
                
                foreach($resultall as $valall){
                    $arrpos[] = $valall->taraz;
                }
                rsort($arrpos);
                $row->position = array_search($row->taraz, $arrpos) + 1;
            }
            
            $row->alist = json_decode($row->alist);
            $row->raw = json_decode($row->raw);
            $row->users_quantity = $users_quantity;
            
            $resultdata_users = $wpdb->get_results("
    	        select qui.*, users.*
    	        from equiz_users_input qui
    	        inner join (select ID as uid, user_login as title from wpsc_users) users on users.uid = qui.userid
    	        where qui.form_id = $qid and qui.raw is not null and qui.deleted = false
            ");
            
            foreach($resultdata_users as $val){
    	        
    	        $user = get_user_by('id', $val->uid);
    	        if($user)
    	            $val->user = $this->getUserData($user);
                
                $val->raw = json_decode($val->raw);
    	    }
            
            $arr = array('status' => true, 'result' => $row, 'resultdata_users' => $resultdata_users);
        }else
            $arr = array('status' => false);
        
        if($r)
            return $arr;
        else
            echo json_encode($arr);
	}
	
	function site_quizview($r = true){
        
        $id = $this->input['id'];
        
        global $wpdb;
        
        $user = wp_get_current_user();
        
        $user_alist_row = $wpdb->get_row("select * from equiz_users_input where form_id = $id and userid = $user->ID");
        $user_alist = json_decode($user_alist_row->alist);
        $qacomp = $this->quizinfo()['qalist'];
        
        echo json_encode(array('qalist' => $user_alist, 'qacomp' => $qacomp));
        
        @$this->logsave(array('act' => 'quizview', 'fn' => 'site_quizview', 'ua' => 'u'));
	}
	
	function site_placementform(){
	    
        global $wpdb;
        
        $qalist = $this->input['qalist'];
        $arrplacement = $this->input['placement'];
        
        $data = array(
            'name' => $arrplacement['name'],
            'phone' => $arrplacement['phone'],
            'email' => $arrplacement['email'],
            'ct' => $this->ct,
            'ip' => $_SERVER['REMOTE_ADDR'],
            'alist' => json_encode($qalist)
        );
        
        $result = $wpdb->insert('equiz_placement', $data);
	}
	
	function site_loadquizinfo_placement(){
        
        global $wpdb;
        
        $ct = 1685765046;
        $result = $wpdb->get_row("select * from equiz_quizzes where deleted = false and ct = $ct");
        if($result !== false){
            
            $arr = array('status' => true, 'info' => $result, 'curct' => $this->ct);
            
            @$this->logsave(array('act' => 'enter placement quiz page', 'fn' => 'site_loadquizinfo_placement', 'ua' => 'u'));
            
        }else{
            
            $arr = array('status' => false);
            @$this->logsave(array('act' => 'enter placement quiz page', 'fn' => 'site_loadquizinfo_placement', 'ua' => 'u', 'err' => true));
        }
        
        echo json_encode($arr);
	}
	
	function site_placementlist(){
        
        global $wpdb;
        
        if(!current_user_can('edit_posts')){
            
            echo json_encode(array('status' => false));
            return;
        }
        
        $result = $wpdb->get_results("select placement, alist, raw, ct from equiz_users_input where placement is not null GROUP BY placement order by id");
        if($result){
            
            foreach($result as $val){
                $val->placement = json_decode($val->placement);
            }
            $arr = array('status' => true, 'list' => $result);
        }else
            $arr = array('status' => false);
        
        echo json_encode($arr);
	}
	
	function estimate_firstdata(){
	    
	    $data['lessonlist'] = $this->generallist('equiz_lessons');
	    $data['status'] = true;
	    echo json_encode($data);
	}
	
	function estimate_datasend(){
	    
	    global $wpdb;
	    
	    $fid = 38;
        $lsnlist = $wpdb->get_results("select * from equiz_lessons where form_id = $fid");
        $obj = $this->input['obj'];
        $arr = array();
        foreach($lsnlist as $val){
            $arr[] = array('raw' => $obj['txt-'.$val->id], 'lesson_id' => $val->id, 'lesson_ratio' => $val->ratio, 'lesson_title' => $val->title);
        }
        
        $insdata = array('form_id' => $fid, 'raw' => json_encode($arr));
        $resins = $wpdb->insert('equiz_users_input', $insdata);
        
        if($resins){
            
            $lid = $wpdb->insert_id;
            
            $result = $this->calcLessonT($fid, true);
            if($result['status']){
                $row = $wpdb->get_row("select * from equiz_users_input where id = $lid");
                $rowclose = $wpdb->get_row("select * from equiz_users_input where form_id = 38 and id <> $lid order by abs(taraz - ".$row->taraz.") limit 1");
                echo json_encode(array('status' => true, 'row' => $row, 'rowclose' => $rowclose));
            }else
                echo json_encode($result);
        }else
            echo json_encode(array('status' => false));
	}
}