var eSiteQuiz = angular.module("eSiteQuiz", ["ngRoute"]);
eSiteQuiz.run(function($rootScope, $http, $location){
    
    $rootScope.cmdurl = '/wp-content/plugins/equiz/site.php';
    $rootScope.user = false;
    $rootScope.quizlist = [], $rootScope.resultlist = [], $rootScope.quizcatlist = [];
    
    let objurl = new URL(location.href);
    $rootScope.quizid = objurl.searchParams.get('id');
    
    $rootScope.loaddata = () => {
        
        $http.post($rootScope.cmdurl, {req:'loaddata'}).then(r => {
            
            console.log(r.data);
            
            if(r.data.status){
                
                if(r.data.lessonlist)$rootScope.lessonlist = r.data.lessonlist.list;
                
                if(r.data.quizlist.status){
                    if(r.data.quizlist)$rootScope.quizlist = r.data.quizlist.list;
                }else{
                    $rootScope.errQuizList = r.data.quizlist.msg;
                }
                
                $rootScope.curct = r.data.curct;
                
                if(r.data.resultlist){
                    
                    if(r.data.resultlist.sd)$rootScope.resultlist = r.data.resultlist.sd;
                    if(r.data.resultlist.lessonlist)$rootScope.lessonlist = r.data.resultlist.lessonlist.list;
                }
                
                if(r.data.quizcatlist)$rootScope.quizcatlist = r.data.quizcatlist.list.filter(x => x.title != 'Test');
                
                $rootScope.user = r.data.curuser;
                localStorage.equiz_user = JSON.stringify($rootScope.user);
            }else
                $rootScope.errmsg = r.data.errmsg;
        });
    };
    $rootScope.loaddata();
    
});

eSiteQuiz.controller('esitectrlQuizList', function($scope, $rootScope, $http, $location, $filter, $interval){
    
    $scope.openQuiz = (q, mode) => {
        
        $rootScope.quiz = q;
        
        localStorage.equiz_quiz = JSON.stringify(q);
        localStorage.equiz_lessonlist = JSON.stringify($rootScope.lessonlist);
        
        if(mode === 'view'){
        
            /*
            if($rootScope.resultlist && $rootScope.resultlist.find(x => x.id == $rootScope.quiz.id)){
                $rootScope.quizview = true;
                $location.path('view');
            }else
                alert('شما در این آزمون شرکت نکرده اید');
            */
            $location.path('view');
        }else{
            
            $rootScope.quizview = false;
            
            if(q.status_code == -1){
                
                if($rootScope.resultlist && $rootScope.resultlist.find(x => x.id == $rootScope.quiz.id))
                    $location.path('result');
                else
                    alert('شما در این آزمون شرکت نکرده اید');
            }else
                if($rootScope.resultlist && $rootScope.resultlist.find(x => x.id == $rootScope.quiz.id))
                    $location.path('result');
                else
                    $location.path('form');
        }
        
    };
    
    $scope.showresult = q => $rootScope.resultlist.find(x => x.id == q.id);
    $scope.showview = q => $rootScope.resultlist.find(x => x.id == q.id) || $rootScope.curct > q.quiz_date_en_time_end;
});

eSiteQuiz.controller('esitectrlQuizResult', function($scope, $rootScope, $http, $location, $filter, $interval){
    
    $rootScope.quiz = $rootScope.quiz ? $rootScope.quiz : JSON.parse(localStorage.equiz_quiz);
    $rootScope.lessonlist = $rootScope.lessonlist ? $rootScope.lessonlist : JSON.parse(localStorage.equiz_lessonlist);
    
    $scope.curq = $rootScope.resultlist.find(x => x.id == $rootScope.quiz.id);
    
    $scope.firstResult = [];
    $scope.lessonlist = [];
    /*
    if(!$scope.curq){
        $scope.errmsg = $rootScope.resultlist.msg;
        console.log($scope.errmsg);
        return;
    }
    */
    $scope.lessonlist = $rootScope.lessonlist.filter(x => x.form_id === $rootScope.quiz.id);
    
    showchart = function(arr){
        
        xValues = [], yValues = [], barColors = [];
        for(let x of arr){
            
            xValues.push(x.lesson_title);
            yValues.push(x.raw);
            //barColors.push("#" + ((1 << 24) * Math.random() | 0).toString(16).padStart(6, "0"));
            barColors.push('cadetblue');
        }

        new Chart("myChart", {
            type: "bar",
            data: {
                labels: xValues,
                datasets: [{
                    backgroundColor: barColors,
                    data: yValues
                }]
            },
            options: {
                legend: {display: false},
                title: {
                    display: true,
                    text: $rootScope.quiz.title
                }
            }
        });
    };
    
    showchartCompare = arr => {
        
        xValues = [], yValues = [], barColors = [], barColors2 = [], yValues2 = [];
        
        for(let x of arr){
            
            xValues.push(x.lesson_title);
            yValues.push(x.raw);
            barColors.push('cadetblue');
            barColors2.push('darkseagreen');
            yValues2.push($rootScope.quiz.result.lessons.find(item => item.id == x.lesson_id).avg);
        }

        new Chart("myChartCompare", {
            type: "bar",
            data: {
                labels: xValues,
                datasets: [{
                    label:'درصدهای شما',
                    backgroundColor: barColors,
                    data: yValues
                },{
                    label:'میانگین داوطلبان',
                    backgroundColor: barColors2,
                    data: yValues2
                }]
            },
            options: {
                legend: {position: 'top'},
                title: {
                    display: true,
                    text: $rootScope.quiz.title
                }
            }
        });
    };
    
    $http.post($rootScope.cmdurl, {req:'myresult', qid:$rootScope.quiz.id}).then(r => {
        
        console.log(r.data);
        
        if(r.data.status){
            
            $scope.result = r.data.result;
            $scope.rawlist = r.data.result.raw;
            showchart($scope.rawlist);
            
            if(r.data.result.taraz){
                
                let sum_correct = 0, sum_incorrect = 0, sum_unsel = 0, sum_raw = 0, avg_raw = 0, sum_ratio = 0;
                r.data.result.raw.forEach(x => {
                    
                    sum_correct += Number(x.correct);
                    sum_incorrect += Number(x.incorrect);
                    sum_unsel += Number(x.unsel);
                    sum_raw += x.raw * x.lesson_ratio;
                    sum_ratio += Number(x.lesson_ratio);
                });
                
                avg_raw = (sum_raw / sum_ratio).toFixed(2);
                esetval('all-correct-quantity', sum_correct);
                esetval('all-incorrect-quantity', sum_incorrect);
                esetval('all-unsel-quantity', sum_unsel);
                esetval('all-raw', avg_raw);
                
                showchartCompare($scope.rawlist);
            }
        }
    });
    
    /*
    showTempResult = () => {
        
        $scope.lessonlist.forEach(lsn => {
            
            let arrqa = $scope.curq.alist.filter(x => lsn.id === x.lesson); console.log(arrqa);
            let obj = {};
            obj.lesson = lsn;
            obj.all = arrqa.length;
            obj.correct = arrqa.filter(x => x.pos === x.uapos).length;
            obj.unsel = arrqa.filter(x => x.uapos === false || x.uapos === undefined).length;
            obj.err = obj.all - (obj.correct + obj.unsel);
            obj.correct100 = Math.round((obj.correct * 3 - obj.err) * 100 / (obj.all * 3));
            
            $scope.firstResult.push(obj);
        });
        
        console.log($scope.firstResult);
        
        showchart($scope.firstResult);
    };
    showTempResult();
    */
});

eSiteQuiz.controller('esitectrlQuizView', function($scope, $rootScope, $http, $location, $filter, $interval){
    
    if(!$rootScope.user)$rootScope.user = JSON.parse(localStorage.equiz_user);
    if(!$rootScope.quiz)$rootScope.quiz = JSON.parse(localStorage.equiz_quiz);
    if(localStorage.equiz_lessonlist)
        if(!$rootScope.lessonlist)$rootScope.lessonlist = JSON.parse(localStorage.equiz_lessonlist);
    
    $scope.lessonlist = $rootScope.lessonlist.filter(x => x.form_id === $rootScope.quiz.id);
    
    $scope.qacounter = qa => $scope.qalist.indexOf(qa) + 1;
    
    $http.post($rootScope.cmdurl, {req:'quizview', id:$rootScope.quiz.id}).then(r => {console.log(r.data);
        
        document.querySelectorAll(".esal").forEach(x => x.classList.remove('d-none'));
        document.querySelectorAll(".ehal").forEach(x => x.classList.add('d-none'));
        
        if(r.data.qalist){
            
            $scope.qalist = r.data.qalist;
            $scope.qalist.forEach(item => {
                
                let x = r.data.qacomp.find(x => x.id == item.id);
                item.pos = x.pos - 1;
                item.desc = x.desc;
                item.q = x.q;
                item.alist = x.alist;
            });
            
        }else
            $scope.qalist = r.data.qacomp.map(x => {x.pos = x.pos - 1; return x;});
    });
    
    $scope.print = () => {
        
        document.querySelector("#header").classList.add('d-print-none');
        document.querySelector("#footer").classList.add('d-print-none');
        print();
    };
});

eSiteQuiz.controller('esitectrlPlacementList', function($scope, $rootScope, $http){
    
    $scope.placementlist = [];
    
    $http.post($rootScope.cmdurl, {req:'placementlist'}).then(r => {
        console.log(r.data);
        $scope.placementlist = r.data.list;
    });
    
    $scope.placementReadToggle = (e, p) => {

        let a = e.target;
        a.classList.remove('fa-check-square', 'fa-square-o');
        a.classList.add('fa-spinner', 'fa-pulse');
        
        $http.post($rootScope.cmdurl, {req:'placement-read-toggle', p:p}).then(r => {
            
            console.log(r.data);
            a.classList.remove('fa-spinner', 'fa-pulse');
            p.placement.read = r.data.read;
            
        });
    };
});

eSiteQuiz.config(function($routeProvider){
	
	$routeProvider
	.when("/", {
		
		templateUrl:"/wp-content/plugins/equiz/site/quizlist.html",
		controller:"esitectrlQuizList"
	})
	.when("/form", {
		
		templateUrl:"/wp-content/plugins/equiz/site/quizform.html",
		controller:"esitectrlQuizForm"
	})
	.when("/result", {
		
		templateUrl:"/wp-content/plugins/equiz/site/quizresult.html",
		controller:"esitectrlQuizResult"
	})
	.when("/view", {
		
		templateUrl:"/wp-content/plugins/equiz/site/quizview.html",
		controller:"esitectrlQuizView"
	})
	.when("/placement", {
		
		templateUrl:"/wp-content/plugins/equiz/site/quizplacement.html",
		controller:"esitectrlQuizPlacement"
	})
	.when("/placementlist", {
	
		templateUrl:"/wp-content/plugins/equiz/site/placementlist.html",
		controller:"esitectrlPlacementList"
	});
	
});